package ru.yandex.direct.i18n.dict;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.direct.i18n.I18NException;

public class PluralEntry3Form implements Entry3Form, PluralEntry {
    private String one;
    private String some;
    private String many;
    private String zero;

    public PluralEntry3Form(String one, String some, String many, String zero) {
        if (one == null || some == null || many == null) {
            throw new I18NException("Dictionary entry forms can't be null");
        }
        this.one = one;
        this.some = some;
        this.many = many;
        this.zero = zero;
    }

    public PluralEntry3Form(String one, String some, String many) {
        this(one, some, many, null);
    }

    @JsonCreator
    public PluralEntry3Form(
            @JsonProperty("one") String one,
            @JsonProperty("some") String some,
            @JsonProperty("many") String many,
            @JsonProperty("zero") String zero,
            @JsonProperty("is_plural") boolean isPlural
    ) {
        this(one, some, many, zero);
        if (!isPlural) {
            throw new I18NException("is_plural property must be true");
        }
    }

    @JsonValue
    public JsonNode toJson() {
        ObjectNode tree = Dictionary.OBJECT_MAPPER.createObjectNode()
                .put("one", one)
                .put("some", some)
                .put("many", many);

        if (zero != null) {
            tree.put("zero", zero);
        }

        tree.put("is_plural", true);

        return tree;
    }

    public String getOne() {
        return one;
    }

    public String getSome() {
        return some;
    }

    public String getMany() {
        return many;
    }

    @Override
    public Optional<String> getZero() {
        return Optional.ofNullable(zero);
    }

    @Override
    public boolean isComplete() {
        return !one.isEmpty() && !some.isEmpty() && !many.isEmpty();
    }

    @Override
    public String toString() {
        return "PluralEntry3Form{" +
                "one='" + one + '\'' +
                ", some='" + some + '\'' +
                ", many='" + many + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        PluralEntry3Form that = (PluralEntry3Form) o;

        if (!one.equals(that.one)) {
            return false;
        }
        if (!some.equals(that.some)) {
            return false;
        }
        return many.equals(that.many);
    }

    @Override
    public int hashCode() {
        int result = one.hashCode();
        result = 31 * result + some.hashCode();
        result = 31 * result + many.hashCode();
        return result;
    }
}
