package ru.yandex.direct.i18n.dict;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.direct.i18n.I18NException;

// Запретить пустые значения в Entry
public class SingularEntry implements Entry2Form, Entry3Form {
    private String form;

    public SingularEntry(String form) {
        if (form == null) {
            throw new I18NException("Dictionary entry forms can't be null");
        }
        this.form = form;
    }

    @JsonCreator
    public SingularEntry(
            @JsonProperty("form") String form,
            @JsonProperty("is_plural") boolean isPlural
    ) {
        this(form);
        if (isPlural) {
            throw new I18NException("is_plural property must be false");
        }
    }

    @JsonValue
    public JsonNode toJson() {
        return Dictionary.OBJECT_MAPPER.createObjectNode()
                .put("form", form)
                .put("is_plural", false);
    }

    public String getForm() {
        return form;
    }

    @Override
    public boolean isComplete() {
        return !form.isEmpty();
    }

    @Override
    public String toString() {
        return "SingularEntry{" +
                "form='" + form + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        SingularEntry that = (SingularEntry) o;

        return form.equals(that.form);
    }

    @Override
    public int hashCode() {
        return form.hashCode();
    }
}
