package ru.yandex.direct.i18n.types;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;

import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.Translator;

import static ru.yandex.direct.i18n.I18NBundle.makeStubTranslatorFactory;

/**
 * Склейка нескольких Translatable в один.
 */
public class ConcatTranslatable implements Translatable {
    private List<? extends Translatable> parts;
    private Collector<CharSequence, ?, String> collector;

    public ConcatTranslatable(Translatable... parts) {
        this(Collectors.joining(), Arrays.asList(parts));
    }

    public ConcatTranslatable(String delimiter, List<? extends Translatable> parts) {
        this(Collectors.joining(delimiter), parts);
    }

    private ConcatTranslatable(Collector<CharSequence, ?, String> collector, List<? extends Translatable> parts) {
        this.parts = parts;
        this.collector = collector;
    }

    @Override
    public String translate(Translator translator) {
        return parts.stream()
                .map(part -> part.translate(translator))
                .collect(collector);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Translator stubTranslator = makeStubTranslatorFactory().getTranslator(new Locale.Builder().setLanguageTag("ru").build());
        ConcatTranslatable that = (ConcatTranslatable) o;
        return this.translate(stubTranslator).equals(that.translate(stubTranslator));
    }

    @Override
    public int hashCode() {
        return Objects.hash(parts, collector);
    }
}
