package ru.yandex.direct.i18n.types;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.Translator;

/**
 * Ничего не переводит. Нужен, чтобы передать строку не требующую перевода (состояющую, например, из цифр)
 * куда-то, где требуется {@link Translatable}.
 */
@ParametersAreNonnullByDefault
public class DummyTranslatable implements Translatable {
    private final String string;

    public DummyTranslatable(String string) {
        this.string = string;
    }

    @Override
    public String translate(Translator translator) {
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DummyTranslatable that = (DummyTranslatable) o;
        return Objects.equals(string, that.string);
    }

    @Override
    public int hashCode() {
        return Objects.hash(string);
    }

    @Override
    public String toString() {
        return string;
    }
}
