package ru.yandex.direct.i18n.types;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;

import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.Translator;

/**
 * Полная локализованная дата
 */
public class FullLocalDate implements Translatable {
    private LocalDate date;

    public FullLocalDate(LocalDate date) {
        this.date = date;
    }

    @Override
    public String translate(Translator translator) {
        return DateTimeFormatter
                .ofLocalizedDate(FormatStyle.LONG)
                .withLocale(translator.getLocale())
                .format(date);
    }
}
