package ru.yandex.direct.i18n.types;

import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.Translator;

/**
 * Идентификатор. Т.е. целое число, которое должно превращаться в строку "как есть",
 * без всяких разделителей разрядов и прочих особенносней локали.
 * Например, Identity(123456789) в русской локали будет преобразовано в "123456789",
 * а не в "123,456,789".
 */
public class Identity implements Translatable {
    private long id;

    public static Identity of(long id) {
        return new Identity(id);
    }

    public Identity(long id) {
        this.id = id;
    }

    @Override
    public String translate(Translator translator) {
        return Long.toString(id);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Identity identity = (Identity) o;

        return id == identity.id;

    }

    @Override
    public int hashCode() {
        return (int) (id ^ (id >>> 32));
    }

    @Override
    public String toString() {
        return "Identity{" +
                "id=" + id +
                '}';
    }
}
