package ru.yandex.direct.i18n.types;

import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.Translator;
import ru.yandex.direct.i18n.bundle.TranslationPluralKey;

/**
 * Множественный перевод. Возвращаемый перевод определяется числительным,
 * входящим в состав key.
 */
public class PluralTranslatable implements Translatable {
    private TranslationPluralKey key;

    public PluralTranslatable(TranslationPluralKey key) {
        this.key = key;
    }

    @Override
    public String translate(Translator translator) {
        return translator.translatePluralKey(key);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        PluralTranslatable that = (PluralTranslatable) o;

        return key.equals(that.key);

    }

    @Override
    public int hashCode() {
        return key.hashCode();
    }

    @Override
    public String toString() {
        return "PluralTranslatable{" +
                "key=" + key +
                '}';
    }
}
