package ru.yandex.direct.i18n.types;

import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.Translator;
import ru.yandex.direct.i18n.bundle.TranslationKey;

public class StringTranslatable implements Translatable {
    private TranslationKey key;

    public StringTranslatable(TranslationKey key) {
        this.key = key;
    }

    @Override
    public String translate(Translator translator) {
        return translator.translateKey(key);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        StringTranslatable that = (StringTranslatable) o;

        return key.equals(that.key);

    }

    @Override
    public int hashCode() {
        return key.hashCode();
    }

    @Override
    public String toString() {
        return "StringTranslatable{" +
                "key=" + key +
                '}';
    }
}
