package ru.yandex.direct.imagesearch;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.CallsPack;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.PartibleQuery;
import ru.yandex.direct.http.smart.http.Query;
import ru.yandex.direct.imagesearch.model.ImageDoc;

@ParametersAreNonnullByDefault
public interface ImageSearchApi {

    public static final String SEARCH_TEXT_PARAM_NAME = "text";

    public static final String IMAGE_SIZE_LARGE = "large";
    public static final String IMAGE_SIZE_MEDIUM = "medium";
    public static final String IMAGE_SIZE_SMALL = "small";
    public static final String IMAGE_SIZE_ANY = "empty";

    @GET("/search/")
    @Json
    CallsPack<List<ImageDoc>> getImageByTextAndDomain(
            @PartibleQuery(SEARCH_TEXT_PARAM_NAME) Set<String> texts,
            @Query("site") String domain,
            @Query("isize") String imageSize,
            @Query("numdoc") int limit,
            @Query("p") int page,
            @Query("family") int familyFilterType,
            @Query("use-common-handle") int useCommonHandle);

    @GET("/search/")
    @Json
    CallsPack<List<ImageDoc>> getImageByText(
            @PartibleQuery(SEARCH_TEXT_PARAM_NAME) Set<String> texts,
            @Query("isize") String imageSize,
            @Query("numdoc") int limit,
            @Query("p") int page,
            @Query("family") int familyFilterType,
            @Query("use-common-handle") int useCommonHandle);

}
