package ru.yandex.direct.imagesearch.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.imagesearch.Utils;

public abstract class AbstractImage {
    @JsonProperty("height")
    private Integer height = null;
    @JsonProperty("width")
    private Integer width = null;
    @JsonProperty("src")
    private String url = null;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AbstractImage {\n");
        sb.append("    url: ").append(Utils.toIndentedString(url)).append("\n");
        sb.append("    height: ").append(Utils.toIndentedString(height)).append("\n");
        sb.append("    width: ").append(Utils.toIndentedString(width)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}
