package ru.yandex.direct.inventori;

import java.time.Duration;

public class InventoriClientConfig {
    private final String baseUrl;
    private final int requestRetries;
    private final Duration requestTimeout;
    private final int parallel;

    public InventoriClientConfig(String baseUrl, int requestRetries, Duration requestTimeout, int parallel) {
        this.baseUrl = baseUrl;
        this.requestRetries = requestRetries;
        this.requestTimeout = requestTimeout;
        this.parallel = parallel;
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public int getRequestRetries() {
        return requestRetries;
    }

    public Duration getRequestTimeout() {
        return requestTimeout;
    }

    public int getParallel() {
        return parallel;
    }

}
