package ru.yandex.direct.inventori;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class InventoriGeneralCampaignsPredictionResponse {
    @JsonProperty("traffic_light_colour")
    @Nonnull
    Long trafficLightColour = 0L;

    @JsonProperty("forecast_impressions")
    @Nullable
    Long forecastImpressions;

    @JsonProperty("impressions_capacity")
    @Nullable
    Long impressionsCapacity;

    public static final Long TRAFFIC_LIGHT_RED = 0L;
    public static final Long TRAFFIC_LIGHT_GREEN = 2L;

    @Nonnull
    public Long getTrafficLightColour() {
        return trafficLightColour;
    }

    @Nullable
    public Long getForecastImpressions() {
        return forecastImpressions;
    }

    @Nullable
    public Long getImpressionsCapacity() {
        return impressionsCapacity;
    }
}
