package ru.yandex.direct.inventori.model.request;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.Objects.requireNonNull;

public class AudienceGroup {
    public enum GroupingType {
        ALL,
        ANY,
        NOT_ANY
    }

    @JsonProperty(value = "grouping_type")
    private GroupingType groupingType;

    @JsonProperty(value = "segments")
    private Set<String> segments;

    public AudienceGroup() {
    }

    public AudienceGroup(GroupingType groupingType, Set<String> segments) {
        this.groupingType = requireNonNull(groupingType);
        this.segments = requireNonNull(segments);
    }

    /**
     * тип группировки (ALL - пересечение, ANY - объединений, NOT_ANY - вычитание из остального траффика)", allowableValues = "ALL,ANY,NOT_ANY
     */
    public GroupingType getGroupingType() {
        return groupingType;
    }

    /**
     * список id я.аудиторий, метрикиw
     */
    public Set<String> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AudienceGroup that = (AudienceGroup) o;
        return groupingType == that.groupingType &&
                Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(groupingType, segments);
    }

    @Override
    public String toString() {
        return "AudienceGroup{" +
                "groupingType=" + groupingType +
                ", segments=" + segments +
                '}';
    }
}
