package ru.yandex.direct.inventori.model.request;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import static com.google.common.base.Preconditions.checkState;

public class AudioCreative {

    @JsonProperty(value = "duration")
    private int duration;

    @JsonProperty(value = "block_size")
    private BlockSize blockSize;

    public AudioCreative() {
    }

    public AudioCreative(int duration, BlockSize blockSize) {
        this.duration = duration;
        this.blockSize = blockSize;
        checkState(duration >= 1000 && duration < 1000_000, "duration must be greater than 1000 and less than 1000000");
    }

    public int getDuration() {
        return duration;
    }

    public BlockSize getBlockSize() {
        return blockSize;
    }

    @Override
    public String toString() {
        return "VideoCreative{" +
                "duration=" + duration +
                ", blockSize=" + blockSize +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AudioCreative that = (AudioCreative) o;
        return duration == that.duration &&
                Objects.equals(blockSize, that.blockSize);
    }

    @Override
    public int hashCode() {
        return Objects.hash(duration, blockSize);
    }
}
