package ru.yandex.direct.inventori.model.request;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class BlockSize {
    @JsonProperty(value = "width")
    private int width;

    @JsonProperty(value = "height")
    private int height;

    public BlockSize() {
    }

    public BlockSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public String toString() {
        return "BlockSize{" +
                "width=" + width +
                ", height=" + height +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        return this == o || (
                o != null
                        && getClass() == o.getClass()
                        && width == ((BlockSize) o).width
                        && height == ((BlockSize) o).height
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(width, height);
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }
}
