package ru.yandex.direct.inventori.model.request;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.Objects.requireNonNull;

public class CampaignParameters {
    @JsonProperty("strategy")
    private CampaignParametersSchedule schedule;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty("rf")
    private CampaignParametersRf rf;
    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = CampaignParametersCorrectionsFilter.class)
    @JsonProperty("corrections")
    private CampaignParametersCorrections corrections;

    public CampaignParameters() {
    }

    public CampaignParameters(CampaignParametersSchedule schedule, CampaignParametersRf rf) {
        this.schedule = requireNonNull(schedule);
        this.rf = requireNonNull(rf);
    }

    public CampaignParameters(CampaignParametersSchedule schedule, CampaignParametersRf rf,
                              CampaignParametersCorrections corrections) {
        this(schedule, rf);
        this.corrections = corrections;
    }

    public void setCorrections(CampaignParametersCorrections corrections) {
        this.corrections = corrections;
    }

    public CampaignParametersCorrections getCorrections() {
        return corrections;
    }

    public CampaignParametersRf getRf() {
        return rf;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignParameters that = (CampaignParameters) o;
        return Objects.equals(schedule, that.schedule) &&
                Objects.equals(rf, that.rf) &&
                Objects.equals(corrections, that.corrections);
    }

    @Override
    public int hashCode() {
        return Objects.hash(schedule, rf, corrections);
    }

    @Override
    public String toString() {
        return "CampaignParameters{" +
                "schedule=" + schedule +
                ", rf=" + rf +
                ", corrections=" + corrections +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CampaignParametersSchedule schedule;
        private CampaignParametersRf rf;
        private CampaignParametersCorrections corrections;

        private Builder() {
        }

        public Builder withSchedule(CampaignParametersSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder withRf(CampaignParametersRf rf) {
            this.rf = rf;
            return this;
        }

        public Builder withCorrections(CampaignParametersCorrections corrections) {
            this.corrections = corrections;
            return this;
        }

        public CampaignParameters build() {
            return new CampaignParameters(schedule, rf, corrections);
        }
    }
}
