package ru.yandex.direct.inventori.model.request;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class CampaignParametersRf {
    @JsonProperty("impressions")
    private int impressions;

    @JsonProperty("days")
    private int days;

    public CampaignParametersRf() {
    }

    public CampaignParametersRf(int impressions, int days) {
        this.impressions = impressions;
        this.days = days;
    }

    public int getImpressions() {
        return impressions;
    }

    public int getDays() {
        return days;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignParametersRf that = (CampaignParametersRf) o;
        return impressions == that.impressions &&
                days == that.days;
    }

    @Override
    public int hashCode() {
        return Objects.hash(impressions, days);
    }
}
