package ru.yandex.direct.inventori.model.request;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.Objects.requireNonNull;

public class CryptaGroup {
    @JsonProperty(value = "segments")
    private Set<String> segments;

    public CryptaGroup() {
    }

    public CryptaGroup(Set<String> segments) {
        this.segments = requireNonNull(segments);
    }

    public CryptaGroup withSegments(Set<String> segments) {
        this.segments = segments;
        return this;
    }

    /**
     * список id сегментов, с учётом keyword'ов может выглядеть так: "123:5"
     */
    public Set<String> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CryptaGroup that = (CryptaGroup) o;
        return Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segments);
    }

    @Override
    public String toString() {
        return "CryptaGroup{" +
                "segments=" + segments +
                '}';
    }
}
