package ru.yandex.direct.inventori.model.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Тип нацеливания
 */
public enum GroupType {

    /**
     * Нацеливание на баннерный инвентарь
     */
    BANNER,

    VIDEO,
    VIDEO_NON_SKIPPABLE,

    INDOOR,

    OUTDOOR,

    AUDIO,

    MAIN_PAGE_AND_NTP,

    BANNER_IN_GEO_APPS,

    // Алиасы для BANNER_IN_GEO_APPS (DIRECT-103936, DIRECT-112325)
    GEOPRODUCT,
    BANNER_IN_METRO,

    GEO_PIN,

    UNKNOWN
    ;

    @JsonValue
    public String value() {
        return this.name();
    }

    @JsonCreator
    public static GroupType parse(String s) {
        return GroupType.valueOf(s);
    }
}
