package ru.yandex.direct.inventori.model.request;

import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.core.entity.currency.model.cpmyndxfrontpage.FrontpageCampaignShowType;

import static ru.yandex.direct.core.entity.currency.model.cpmyndxfrontpage.FrontpageCampaignShowType.FRONTPAGE;
import static ru.yandex.direct.core.entity.currency.model.cpmyndxfrontpage.FrontpageCampaignShowType.FRONTPAGE_MOBILE;

public enum MainPageTrafficType {

    DESKTOP,

    MOBILE,

    BROWSER_NEW_TAB,

    ALL,
    ;

    @JsonValue
    public String value() {
        return this.name();
    }

    @JsonCreator
    public static MainPageTrafficType parse(String s) {
        return MainPageTrafficType.valueOf(s);
    }

    public static MainPageTrafficType convert(Set<FrontpageCampaignShowType> showTypes) {
        boolean desktopIsAllowed = showTypes.contains(FRONTPAGE);
        boolean mobileIsAllowed = showTypes.contains(FRONTPAGE_MOBILE);
        boolean browserNewTabIsAllowed = showTypes.contains(FrontpageCampaignShowType.BROWSER_NEW_TAB);

        if (desktopIsAllowed && mobileIsAllowed) {
            return MainPageTrafficType.ALL;
        } else if (desktopIsAllowed) {
            return MainPageTrafficType.DESKTOP;
        } else if (mobileIsAllowed) {
            return MainPageTrafficType.MOBILE;
        } else if (browserNewTabIsAllowed) {
            // DIRECT-114633: [java] Поставить заглушку для инвентори: ntp == desktop
            return MainPageTrafficType.DESKTOP;
        }
        return null;
    }
}
