package ru.yandex.direct.inventori.model.request;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.Objects.requireNonNull;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class PageBlock {

    @JsonProperty(value = "page_id")
    private Long pageId;

    @JsonProperty(value = "blocks_ids")
    private List<Long> blocksIds;

    public PageBlock() {
    }

    public PageBlock(Long pageId, @Nullable List<Long> blocksIds) {
        this.pageId = requireNonNull(pageId);
        this.blocksIds = blocksIds;
    }

    public Long getPageId() {
        return pageId;
    }

    public List<Long> getBlocksIds() {
        return blocksIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PageBlock pageBlock = (PageBlock) o;
        return pageId.equals(pageBlock.pageId) &&
                blocksIds.equals(pageBlock.blocksIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pageId, blocksIds);
    }

    @Override
    public String toString() {
        return "PageBlock{" +
                "pageId=" + pageId +
                ", blocksIds=" + blocksIds +
                '}';
    }
}
