package ru.yandex.direct.inventori.model.request;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class PlatformCorrections {

    @JsonProperty(value = "desktop")
    private Integer desktop;

    @JsonProperty(value = "mobile")
    private Integer mobile;

    @JsonProperty(value = "mobile_os_type")
    private MobileOsType mobileOsType;

    public PlatformCorrections() {
    }

    public PlatformCorrections(Integer desktop, Integer mobile, MobileOsType mobileOsType) {
        this.desktop = desktop;
        this.mobile = mobile;
        this.mobileOsType = mobileOsType;
    }

    public Integer getDesktop() {
        return desktop;
    }

    public Integer getMobile() {
        return mobile;
    }

    public MobileOsType getMobileOsType() {
        return mobileOsType;
    }

    @Override
    public String toString() {
        return "PlatformCorrections{" +
                "desktop=" + desktop +
                ", mobile=" + mobile +
                ", mobileOsType=" + mobileOsType +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PlatformCorrections that = (PlatformCorrections) o;
        return Objects.equals(desktop, that.desktop) &&
                Objects.equals(mobile, that.mobile) &&
                Objects.equals(mobileOsType, that.mobileOsType);
    }

    @Override
    public int hashCode() {

        return Objects.hash(desktop, mobile, mobileOsType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer desktop;
        private Integer mobile;
        private MobileOsType mobileOsType;

        private Builder() {
        }

        public Builder withDesktop(Integer desktop) {
            this.desktop = desktop;
            return this;
        }

        public Builder withMobile(Integer mobile) {
            this.mobile = mobile;
            return this;
        }

        public Builder withMobileOsType(MobileOsType mobileOsType) {
            this.mobileOsType = mobileOsType;
            return this;
        }

        public PlatformCorrections build() {
            return desktop == null && mobile == null && mobileOsType == null ? null
                    : new PlatformCorrections(desktop, mobile, mobileOsType);
        }
    }
}
