package ru.yandex.direct.inventori.model.request;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static com.google.common.base.Preconditions.checkState;
import static java.util.Objects.requireNonNull;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ProfileCorrection {

    public enum Gender {
        @JsonProperty("male")
        MALE,
        @JsonProperty("female")
        FEMALE
    }

    public enum Age {
        @JsonProperty("<18")
        _0_17,
        @JsonProperty("18-24")
        _18_24,
        @JsonProperty("25-34")
        _25_34,
        @JsonProperty("35-44")
        _35_44,
        @JsonProperty("45-54")
        _45_54,
        @JsonProperty(">=55")
        _55_
    }

    @JsonProperty(value = "gender")
    private Gender gender;

    @JsonProperty(value = "age")
    private Age age;

    @JsonProperty(value = "correction")
    private Integer correction;

    public ProfileCorrection() {
    }

    public ProfileCorrection(Gender gender, Age age, Integer correction) {
        this.gender = gender;
        this.age = age;
        this.correction = requireNonNull(correction);
        checkState(gender != null || age != null, "gender or age must not be null");
    }

    public Gender getGender() {
        return gender;
    }

    public Age getAge() {
        return age;
    }

    public Integer getCorrection() {
        return correction;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProfileCorrection that = (ProfileCorrection) o;
        return gender == that.gender &&
                age == that.age &&
                Objects.equals(correction, that.correction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(gender, age, correction);
    }

    @Override
    public String toString() {
        return "ProfileCorrection{" +
                "gender=" + gender +
                ", age=" + age +
                ", correction=" + correction +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Gender gender;
        private Age age;
        private Integer correction;

        private Builder() {
        }

        public Builder withGender(Gender gender) {
            this.gender = gender;
            return this;
        }

        public Builder withAge(Age age) {
            this.age = age;
            return this;
        }

        public Builder withCorrection(Integer correction) {
            this.correction = correction;
            return this;
        }

        public ProfileCorrection build() {
            return new ProfileCorrection(gender, age, correction);
        }
    }
}
