package ru.yandex.direct.inventori.model.request;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

import static java.util.stream.Collectors.toList;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ProjectParameter implements Comparable{
    @JsonProperty(value = "keyword")
    private Long keyword;

    @JsonProperty(value = "values")
    private List<Long> values;

    public ProjectParameter() {
    }

    public ProjectParameter(Long keyword, List<Long> values) {
        this.keyword = keyword;
        this.values = values;
    }

    public Long getKeyword() {
        return keyword;
    }

    public List<Long> getValues() {
        return values;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProjectParameter that = (ProjectParameter) o;
        return keyword.equals(that.keyword) &&
                values.stream().sorted().collect(toList()).equals(that.values.stream().sorted().collect(toList()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(keyword, values);
    }

    @Override
    public String toString() {
        return "ProjectParameter{" +
                "keyword=" + keyword +
                ", values=" + values +
                '}';
    }

    @Override
    public int compareTo(@NotNull Object o) {
        if (this == o) {
            return 0;
        }
        if (getClass() != o.getClass()) {
            return -1;
        }
        ProjectParameter that = (ProjectParameter) o;
        return keyword.compareTo(that.getKeyword());
    }
}
