package ru.yandex.direct.inventori.model.request;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class TrafficTypeCorrections {

    private static final int NON_MODIFICATION_CORRECTION = 100;

    @JsonProperty("banner")
    private int banner;
    @JsonProperty("video_inpage")
    private int videoInpage;
    @JsonProperty("video_instream")
    private int videoInstream;
    @JsonProperty("video_interstitial")
    private int videoInterstitial;
    @JsonProperty("video_in_banner")
    private int videoInbanner;
    @JsonProperty("video_rewarded")
    private int videoRewarded;

    public TrafficTypeCorrections() {
    }

    public TrafficTypeCorrections(Integer banner, Integer videoInpage, Integer videoInstream, Integer videoInterstitial,
                                  Integer videoInbanner, Integer videoRewarded) {
        this.banner = adjustCorrection(banner);
        this.videoInpage = adjustCorrection(videoInpage);
        this.videoInstream = adjustCorrection(videoInstream);
        this.videoInterstitial = adjustCorrection(videoInterstitial);
        this.videoInbanner = adjustCorrection(videoInbanner);
        this.videoRewarded = adjustCorrection(videoRewarded);
    }

    public int getBanner() {
        return banner;
    }

    public int getVideoInpage() {
        return videoInpage;
    }

    public int getVideoInstream() {
        return videoInstream;
    }

    public int getVideoInterstitial() {
        return videoInterstitial;
    }

    public int getVideoInbanner() {
        return videoInbanner;
    }

    public void setVideoInbanner(int videoInbanner) {
        this.videoInbanner = videoInbanner;
    }

    public int getVideoRewarded() {
        return videoRewarded;
    }

    private static int adjustCorrection(Integer correction) {
        return correction != null ? correction : NON_MODIFICATION_CORRECTION;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrafficTypeCorrections that = (TrafficTypeCorrections) o;
        return banner == that.banner &&
                videoInpage == that.videoInpage &&
                videoInstream == that.videoInstream &&
                videoInterstitial == that.videoInterstitial &&
                videoInbanner == that.videoInbanner &&
                videoRewarded == that.videoRewarded;
    }

    @Override
    public int hashCode() {
        return Objects.hash(banner, videoInpage, videoInstream, videoInterstitial, videoInbanner, videoRewarded);
    }
}
