package ru.yandex.direct.inventori.model.request;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static com.google.common.base.Preconditions.checkState;
import static java.lang.String.format;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class VideoCreative {

    @JsonProperty(value = "duration")
    private int duration;

    @JsonProperty(value = "size")
    private BlockSize blockSize;

    @JsonProperty(value = "proportions")
    private Set<BlockSize> proportions;

    public VideoCreative() {
    }

    public VideoCreative(Long creativeId, int duration, BlockSize blockSize, Set<BlockSize> proportions) {
        this.duration = duration;
        this.blockSize = blockSize;
        this.proportions = proportions;
        checkState(duration >= 1_000 && duration < 1_000_000,
                format("invalid creative %d: duration must be greater than 1000 and less than 1000000", creativeId));
        checkState(blockSize != null || proportions != null,
                format("invalid creative %d: blockSizes or proportions must not be null", creativeId));
    }

    public VideoCreative(int duration, BlockSize blockSize, Set<BlockSize> proportions) {
        this(null, duration, blockSize, proportions);
    }

    public int getDuration() {
        return duration;
    }

    public BlockSize getBlockSize() {
        return blockSize;
    }

    public Set<BlockSize> getProportions() {
        return proportions;
    }

    @Override
    public String toString() {
        return "VideoCreative{" +
                "duration=" + duration +
                ", blockSize=" + blockSize +
                ", proportions=" + proportions +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        VideoCreative that = (VideoCreative) o;
        return duration == that.duration &&
                Objects.equals(blockSize, that.blockSize) &&
                Objects.equals(proportions, that.proportions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(duration, blockSize, proportions);
    }
}
