package ru.yandex.direct.inventori.model.response;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import ru.yandex.direct.inventori.model.response.error.PredictionResponseError;

@JsonDeserialize(using = JsonDeserializer.None.class)
public class CampaignPredictionAvailableResponse extends CampaignPredictionResponse {
    @JsonProperty("recommended_cpm")
    private final Long recommendedCpm;
    @JsonProperty("cpm_for_red_to_yellow_gradient_start")
    private final Long cpmForRedToYellowGradientStart;
    @JsonProperty("cpm_for_red_to_yellow_gradient_end")
    private final Long cpmForRedToYellowGradientEnd;
    @JsonProperty("cpm_for_yellow_to_green_gradient_start")
    private final Long cpmForYellowToGreenGradientStart;
    @JsonProperty("cpm_for_yellow_to_green_gradient_end")
    private final Long cpmForYellowToGreenGradientEnd;
    @JsonProperty("recommended_cpv")
    private final Long recommendedCpv;
    @JsonProperty("cpv_for_red_to_yellow_gradient_start")
    private final Long cpvForRedToYellowGradientStart;
    @JsonProperty("cpv_for_red_to_yellow_gradient_end")
    private final Long cpvForRedToYellowGradientEnd;
    @JsonProperty("cpv_for_yellow_to_green_gradient_start")
    private final Long cpvForYellowToGreenGradientStart;
    @JsonProperty("cpv_for_yellow_to_green_gradient_end")
    private final Long cpvForYellowToGreenGradientEnd;

    public CampaignPredictionAvailableResponse(
            @JsonProperty("errors") List<PredictionResponseError> errors,
            @JsonProperty("recommended_cpm") Long recommendedCpm,
            @JsonProperty("cpm_for_red_to_yellow_gradient_start") Long cpmForRedToYellowGradientStart,
            @JsonProperty("cpm_for_red_to_yellow_gradient_end") Long cpmForRedToYellowGradientEnd,
            @JsonProperty("cpm_for_yellow_to_green_gradient_start") Long cpmForYellowToGreenGradientStart,
            @JsonProperty("cpm_for_yellow_to_green_gradient_end") Long cpmForYellowToGreenGradientEnd,
            @JsonProperty("recommended_cpv") Long recommendedCpv,
            @JsonProperty("cpv_for_red_to_yellow_gradient_start") Long cpvForRedToYellowGradientStart,
            @JsonProperty("cpv_for_red_to_yellow_gradient_end") Long cpvForRedToYellowGradientEnd,
            @JsonProperty("cpv_for_yellow_to_green_gradient_start") Long cpvForYellowToGreenGradientStart,
            @JsonProperty("cpv_for_yellow_to_green_gradient_end") Long cpvForYellowToGreenGradientEnd) {
        super(errors);
        this.recommendedCpm = recommendedCpm;
        this.cpmForRedToYellowGradientStart = cpmForRedToYellowGradientStart;
        this.cpmForRedToYellowGradientEnd = cpmForRedToYellowGradientEnd;
        this.cpmForYellowToGreenGradientStart = cpmForYellowToGreenGradientStart;
        this.cpmForYellowToGreenGradientEnd = cpmForYellowToGreenGradientEnd;
        this.recommendedCpv = recommendedCpv;
        this.cpvForRedToYellowGradientStart = cpvForRedToYellowGradientStart;
        this.cpvForRedToYellowGradientEnd = cpvForRedToYellowGradientEnd;
        this.cpvForYellowToGreenGradientStart = cpvForYellowToGreenGradientStart;
        this.cpvForYellowToGreenGradientEnd = cpvForYellowToGreenGradientEnd;
    }

    @Nullable
    public Long getRecommendedCpm() {
        return recommendedCpm;
    }

    @Nullable
    public Long getCpmForRedToYellowGradientStart() {
        return cpmForRedToYellowGradientStart;
    }

    @Nullable
    public Long getCpmForRedToYellowGradientEnd() {
        return cpmForRedToYellowGradientEnd;
    }

    @Nullable
    public Long getCpmForYellowToGreenGradientStart() {
        return cpmForYellowToGreenGradientStart;
    }

    @Nullable
    public Long getCpmForYellowToGreenGradientEnd() {
        return cpmForYellowToGreenGradientEnd;
    }

    @Nullable
    public Long getRecommendedCpv() {
        return recommendedCpv;
    }

    @Nullable
    public Long getCpvForRedToYellowGradientStart() {
        return cpvForRedToYellowGradientStart;
    }

    @Nullable
    public Long getCpvForRedToYellowGradientEnd() {
        return cpvForRedToYellowGradientEnd;
    }

    @Nullable
    public Long getCpvForYellowToGreenGradientStart() {
        return cpvForYellowToGreenGradientStart;
    }

    @Nullable
    public Long getCpvForYellowToGreenGradientEnd() {
        return cpvForYellowToGreenGradientEnd;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignPredictionAvailableResponse that = (CampaignPredictionAvailableResponse) o;
        return Objects.equals(recommendedCpm, that.recommendedCpm) &&
                Objects.equals(cpmForRedToYellowGradientStart, that.cpmForRedToYellowGradientStart) &&
                Objects.equals(cpmForRedToYellowGradientEnd, that.cpmForRedToYellowGradientEnd) &&
                Objects.equals(cpmForYellowToGreenGradientStart, that.cpmForYellowToGreenGradientStart) &&
                Objects.equals(cpmForYellowToGreenGradientEnd, that.cpmForYellowToGreenGradientEnd) &&
                Objects.equals(recommendedCpv, that.recommendedCpv) &&
                Objects.equals(cpvForRedToYellowGradientStart, that.cpvForRedToYellowGradientStart) &&
                Objects.equals(cpvForRedToYellowGradientEnd, that.cpvForRedToYellowGradientEnd) &&
                Objects.equals(cpvForYellowToGreenGradientStart, that.cpvForYellowToGreenGradientStart) &&
                Objects.equals(cpvForYellowToGreenGradientEnd, that.cpvForYellowToGreenGradientEnd);
    }

    @Override
    public int hashCode() {
        return Objects.hash(recommendedCpm, cpmForRedToYellowGradientStart, cpmForRedToYellowGradientEnd,
                cpmForYellowToGreenGradientStart, cpmForYellowToGreenGradientEnd,
                recommendedCpv,
                cpvForRedToYellowGradientStart,
                cpvForRedToYellowGradientEnd,
                cpvForYellowToGreenGradientStart,
                cpvForYellowToGreenGradientEnd);
    }
}
