package ru.yandex.direct.inventori.model.response;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import ru.yandex.direct.inventori.model.response.error.PredictionResponseError;

@JsonDeserialize(using = JsonDeserializer.None.class)
public class CampaignPredictionLowReachResponse extends CampaignPredictionResponse {
    @JsonProperty("reach_less_than")
    private final long reachLessThan;

    public CampaignPredictionLowReachResponse(
            @JsonProperty("errors") List<PredictionResponseError> errors,
            @JsonProperty("reach_less_than") long reachLessThan) {
        super(errors);
        this.reachLessThan = reachLessThan;
    }

    public long getReachLessThan() {
        return reachLessThan;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignPredictionLowReachResponse that = (CampaignPredictionLowReachResponse) o;
        return reachLessThan == that.reachLessThan;
    }

    @Override
    public int hashCode() {
        return Objects.hash(reachLessThan);
    }
}
