package ru.yandex.direct.inventori.model.response;

import java.util.List;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableList;

import ru.yandex.direct.inventori.model.response.error.PredictionResponseError;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.utils.CommonUtils.nvl;

@JsonDeserialize(using = CampaignPredictionResponseDeserializer.class)
public abstract class CampaignPredictionResponse {
    @JsonProperty("errors")
    private final ImmutableList<PredictionResponseError> errors;

    @JsonCreator
    public CampaignPredictionResponse(@JsonProperty("errors") List<PredictionResponseError> errors) {
        this.errors = ImmutableList.copyOf(nvl(errors, emptyList()));
    }

    @Nonnull
    public ImmutableList<PredictionResponseError> getErrors() {
        return errors;
    }
}
