package ru.yandex.direct.inventori.model.response;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;

public class CampaignPredictionResponseDeserializer extends StdDeserializer<CampaignPredictionResponse> {

    protected CampaignPredictionResponseDeserializer() {
        super(CampaignPredictionResponse.class);
    }

    @Override
    public CampaignPredictionResponse deserialize(JsonParser p, DeserializationContext ctxt)
            throws IOException {
        TreeNode node = p.readValueAsTree();

        // Select the concrete class based on the existence of a property
        if (node.get("reach_less_than") != null) {
            return p.getCodec().treeToValue(node, CampaignPredictionLowReachResponse.class);
        }
        if (node.get("traffic_light_colour") != null) {
            if (node.get("predicted_impressions_left_border") != null) {
                return p.getCodec().treeToValue(node, GeneralRecommendationResponse.class);
            }
            if (node.get("sov_by_reach") != null) {
                return p.getCodec().treeToValue(node, GeneralCampaignPredictionResponse.class);
            }
            return p.getCodec().treeToValue(node, TrafficLightPredictionResponse.class);

        }
        if (node.get("target_reach") != null) {
            return p.getCodec().treeToValue(node, MultiBudgetsPredictionResponse.class);
        }
        return p.getCodec().treeToValue(node, CampaignPredictionAvailableResponse.class);
    }
}
