package ru.yandex.direct.inventori.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.inventori.model.response.error.ErrorsEntry;

public class ForecastResponse {
    private Long reach;
    private Long reachLessThan;
    private List<ErrorsEntry> errors;

    public ForecastResponse() {
    }

    /**
     * @return охват по заданным критериям
     */
    @JsonProperty("reach")
    public Long getReach() {
        return reach;
    }

    /**
     * @return расчетный охват меньше чем нижнее ограничение
     */
    @JsonProperty("reach_less_than")
    public Long getReachLessThan() {
        return reachLessThan;
    }

    @JsonProperty("errors")
    public List<ErrorsEntry> getErrors() {
        return errors;
    }

    public ForecastResponse withReach(Long reach) {
        this.reach = reach;
        return this;
    }
}
