package ru.yandex.direct.inventori.model.response;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import ru.yandex.direct.inventori.model.response.error.PredictionResponseError;

@JsonDeserialize(using = JsonDeserializer.None.class)
public class GeneralCampaignPredictionResponse extends CampaignPredictionResponse {
    @JsonProperty("target_reach")
    private final Long targetReach;
    @JsonProperty("impressions_capacity")
    private final Long impressionsCapacity;
    @JsonProperty("forecast_reach")
    private final Long forecastReach;
    @JsonProperty("sov_by_reach")
    private final Double sovByReach;
    @JsonProperty("sov_by_impressions")
    private final Double sovByImpressions;
    @JsonProperty("forecast_impressions")
    private final Long forecastImpressions;
    @JsonProperty("forecast_budget")
    private final Long forecastBudget;
    @JsonProperty("forecast_cpm")
    private final Long forecastCpm;
    @JsonProperty("recommended_max_avg_cpm")
    private final Long recommendedMaxAvgCpm;
    @JsonProperty("traffic_light_colour")
    private final Integer trafficLightColour;
    @JsonProperty("true_views_capacity")
    private final Long trueViewsCapacity;
    @JsonProperty("forecast_true_views")
    private final Long forecastTrueViews;
    @JsonProperty("sov_by_true_views")
    private final Double sovByTrueViews;
    @JsonProperty("forecast_cpv")
    private final Long forecastCpv;
    @JsonProperty("recommended_max_avg_cpv")
    private final Long recommendedMaxAvgCpv;

    public GeneralCampaignPredictionResponse(
            @JsonProperty("errors") List<PredictionResponseError> errors,
            @JsonProperty("target_reach") Long targetReach,
            @JsonProperty("impressions_capacity") Long impressionsCapacity,
            @JsonProperty("forecast_reach") Long forecastReach,
            @JsonProperty("sov_by_reach") Double sovByReach,
            @JsonProperty("sov_by_impressions") Double sovByImpressions,
            @JsonProperty("forecast_impressions") Long forecastImpressions,
            @JsonProperty("forecast_budget") Long forecastBudget,
            @JsonProperty("forecast_cpm") Long forecastCpm,
            @JsonProperty("recommended_max_avg_cpm") Long recommendedMaxAvgCpm,
            @JsonProperty("traffic_light_colour") Integer trafficLightColour,
            @JsonProperty("true_views_capacity") Long trueViewsCapacity,
            @JsonProperty("forecast_true_views") Long forecastTrueViews,
            @JsonProperty("sov_by_true_views") Double sovByTrueViews,
            @JsonProperty("forecast_cpv") Long forecastCpv,
            @JsonProperty("recommended_max_avg_cpv") Long recommendedMaxAvgCpv
        ) {
        super(errors);
        this.targetReach = targetReach;
        this.impressionsCapacity = impressionsCapacity;
        this.forecastReach = forecastReach;
        this.sovByReach = sovByReach;
        this.sovByImpressions = sovByImpressions;
        this.forecastImpressions = forecastImpressions;
        this.forecastBudget = forecastBudget;
        this.forecastCpm = forecastCpm;
        this.recommendedMaxAvgCpm = recommendedMaxAvgCpm;
        this.trafficLightColour = trafficLightColour;
        this.trueViewsCapacity = trueViewsCapacity;
        this.forecastTrueViews = forecastTrueViews;
        this.sovByTrueViews = sovByTrueViews;
        this.forecastCpv = forecastCpv;
        this.recommendedMaxAvgCpv = recommendedMaxAvgCpv;
    }

    public Long getTargetReach() {
        return targetReach;
    }

    @Nullable
    public Long getImpressionsCapacity() {
        return impressionsCapacity;
    }

    public Long getForecastReach() {
        return forecastReach;
    }

    public Double getSovByReach() {
        return sovByReach;
    }

    @Nullable
    public Double getSovByImpressions() {
        return sovByImpressions;
    }

    @Nullable
    public Long getForecastImpressions() {
        return forecastImpressions;
    }

    public Long getForecastBudget() {
        return forecastBudget;
    }

    public Long getForecastCpm() {
        return forecastCpm;
    }

    public Long getRecommendedMaxAvgCpm() {
        return recommendedMaxAvgCpm;
    }

    public Integer getTrafficLightColour() {
        return trafficLightColour;
    }

    @Nullable
    public Long getTrueViewsCapacity() {
        return trueViewsCapacity;
    }

    @Nullable
    public Long getForecastTrueViews() {
        return forecastTrueViews;
    }

    @Nullable
    public Double getSovByTrueViews() {
        return sovByTrueViews;
    }

    public Long getForecastCpv() {
        return forecastCpv;
    }

    public Long getRecommendedMaxAvgCpv() {
        return recommendedMaxAvgCpv;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GeneralCampaignPredictionResponse that = (GeneralCampaignPredictionResponse) o;
        return Objects.equals(targetReach, that.targetReach) &&
                Objects.equals(impressionsCapacity, that.impressionsCapacity) &&
                Objects.equals(forecastReach, that.forecastReach) &&
                Objects.equals(sovByReach, that.sovByReach) &&
                Objects.equals(sovByImpressions, that.sovByImpressions) &&
                Objects.equals(forecastImpressions, that.forecastImpressions) &&
                Objects.equals(forecastBudget, that.forecastBudget) &&
                Objects.equals(forecastCpm, that.forecastCpm) &&
                Objects.equals(recommendedMaxAvgCpm, that.recommendedMaxAvgCpm) &&
                Objects.equals(trafficLightColour, that.trafficLightColour) &&
                Objects.equals(trueViewsCapacity, that.trueViewsCapacity) &&
                Objects.equals(forecastTrueViews, that.forecastTrueViews) &&
                Objects.equals(sovByTrueViews, that.sovByTrueViews) &&
                Objects.equals(forecastCpv, that.forecastCpv) &&
                Objects.equals(recommendedMaxAvgCpv, that.recommendedMaxAvgCpv);
    }

    @Override
    public int hashCode() {
        return Objects.hash(targetReach, impressionsCapacity, forecastReach, sovByReach, sovByImpressions,
                forecastImpressions, forecastBudget, forecastCpm, recommendedMaxAvgCpm, trafficLightColour,
                trueViewsCapacity,
                forecastTrueViews,
                sovByTrueViews,
                forecastCpv,
                recommendedMaxAvgCpv);
    }
}
