package ru.yandex.direct.inventori.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import ru.yandex.direct.inventori.model.response.error.PredictionResponseError;

@JsonDeserialize(using = JsonDeserializer.None.class)
public class GeneralRecommendationResponse extends CampaignPredictionResponse {

    /**
     * рекомендуемый СРМ в микрорублях за 1000 показов
     */
    @JsonProperty(value = "recommended_max_avg_cpm")
    private final Long recommendedMaxAvgCpm;

    /**
     * рекомендуемый CPV в микрорублях за 1 true-view событие
     */
    @JsonProperty(value = "recommended_max_avg_cpv")
    private final Long recommendedMaxAvgCpv;

    /**
     * цвет светофора (0 - красный, 2 - зеленый) с текущими настройками кампании
     */
    @JsonProperty(value = "traffic_light_colour")
    private final Integer trafficLightColourId;

    /**
     * левая граница доверительного интервала для прогнозных показов
     */
    @JsonProperty("predicted_impressions_left_border")
    private final Long predictedImpressionsLeftBorder;

    /**
     * левая граница доверительного интервала для прогнозных показов
     */
    @JsonProperty("predicted_impressions_right_border")
    private final Long predictedImpressionsRightBorder;

    /**
     * левая граница доверительного интервала для прогнозных true-view событий
     */
    @JsonProperty("predicted_true_views_left_border")
    private final Long predictedTrueViewsLeftBorder;

    /**
     * левая граница доверительного интервала для прогнозных true-view событий
     */
    @JsonProperty("predicted_true_views_right_border")
    private final Long predictedTrueViewsRightBorder;

    /**
     * левая граница доверительного интервала для прогнозного охвата
     */
    @JsonProperty(value = "predicted_reach_left_border")
    private final Long predictedReachLeftBorder;

    /**
     * левая граница доверительного интервала для прогнозного охвата
     */
    @JsonProperty(value = "predicted_reach_right_border")
    private final Long predictedReachRightBorder;

    public GeneralRecommendationResponse(
            @JsonProperty("errors") List<PredictionResponseError> errors,
            @JsonProperty("predicted_impressions_left_border") Long predictedImpressionsLeftBorder,
            @JsonProperty("predicted_impressions_right_border") Long predictedImpressionsRightBorder,
            @JsonProperty("predicted_true_views_left_border") Long predictedTrueViewsLeftBorder,
            @JsonProperty("predicted_true_views_right_border") Long predictedTrueViewsRightBorder,
            @JsonProperty(value = "recommended_max_avg_cpm") Long recommendedMaxAvgCpm,
            @JsonProperty(value = "recommended_max_avg_cpv") Long recommendedMaxAvgCpv,
            @JsonProperty(value = "predicted_reach_left_border") Long predictedReachLeftBorder,
            @JsonProperty(value = "predicted_reach_right_border") Long predictedReachRightBorder,
            @JsonProperty(value = "traffic_light_colour") Integer trafficLightColourId)
    {
        super(errors);
        this.predictedImpressionsLeftBorder = predictedImpressionsLeftBorder;
        this.predictedImpressionsRightBorder = predictedImpressionsRightBorder;
        this.predictedTrueViewsLeftBorder = predictedTrueViewsLeftBorder;
        this.predictedTrueViewsRightBorder = predictedTrueViewsRightBorder;
        this.recommendedMaxAvgCpm = recommendedMaxAvgCpm;
        this.recommendedMaxAvgCpv = recommendedMaxAvgCpv;
        this.predictedReachLeftBorder = predictedReachLeftBorder;
        this.predictedReachRightBorder = predictedReachRightBorder;
        this.trafficLightColourId = trafficLightColourId;
    }

    public Long getPredictedImpressionsLeftBorder() {
        return predictedImpressionsLeftBorder;
    }

    public Long getPredictedImpressionsRightBorder() {
        return predictedImpressionsRightBorder;
    }

    public Long getPredictedTrueViewsLeftBorder() {
        return predictedTrueViewsLeftBorder;
    }

    public Long getPredictedTrueViewsRightBorder() {
        return predictedTrueViewsRightBorder;
    }

    public Long getRecommendedMaxAvgCpm() {
        return recommendedMaxAvgCpm;
    }

    public Long getRecommendedMaxAvgCpv() {
        return recommendedMaxAvgCpv;
    }

    public Long getPredictedReachLeftBorder() {
        return predictedReachLeftBorder;
    }

    public Long getPredictedReachRightBorder() {
        return predictedReachRightBorder;
    }

    public Integer getTrafficLightColourId() {
        return trafficLightColourId;
    }
}
