package ru.yandex.direct.inventori.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import ru.yandex.direct.inventori.model.response.error.PredictionResponseError;

@JsonDeserialize(using = JsonDeserializer.None.class)
public class MultiBudgetsPredictionResponse extends CampaignPredictionResponse {

    private Long predictionTargetReach;

    private List<IntervalPredictionResult> intervalPredictionResults;

    public MultiBudgetsPredictionResponse(
            @JsonProperty("errors") List<PredictionResponseError> errors,
            @JsonProperty("target_reach") Long predictionTargetReach,
            @JsonProperty("interval_prediction_results") List<IntervalPredictionResult> intervalPredictionResults) {
        super(errors);
        this.predictionTargetReach = predictionTargetReach;
        this.intervalPredictionResults = intervalPredictionResults;
    }

    public MultiBudgetsPredictionResponse(List<PredictionResponseError> errors) {
        super(errors);
    }

    public Long getPredictionTargetReach() {
        return predictionTargetReach;
    }

    public List<IntervalPredictionResult> getIntervalPredictionResults() {
        return intervalPredictionResults;
    }

    @JsonDeserialize(using = JsonDeserializer.None.class)
    public static class IntervalPredictionResult {
        private Long budget;

        private Long predictionReach;

        private Long leftPredictionReachBorder;

        private Long rightPredictionReachBorder;

        public IntervalPredictionResult(@JsonProperty("budget") Long budget,
                                        @JsonProperty("reach") Long predictionReach,
                                        @JsonProperty("left_reach_border") Long leftPredictionReachBorder,
                                        @JsonProperty("right_reach_border") Long rightPredictionReachBorder) {
            this.budget = budget;
            this.predictionReach = predictionReach;
            this.leftPredictionReachBorder = leftPredictionReachBorder;
            this.rightPredictionReachBorder = rightPredictionReachBorder;
        }

        public Long getBudget() {
            return budget;
        }

        public Long getPredictionReach() {
            return predictionReach;
        }

        public Long getLeftPredictionReachBorder() {
            return leftPredictionReachBorder;
        }

        public Long getRightPredictionReachBorder() {
            return rightPredictionReachBorder;
        }
    }
}
