package ru.yandex.direct.inventori.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.inventori.model.response.error.ErrorsEntry;

public class OutdoorPredictionResponse {

    @JsonProperty("reach")
    private Long reach;

    @JsonProperty("ots_capacity")
    private Long otsCapacity;

    @JsonProperty("reach_less_than")
    private Long reachLessThan;

    @JsonProperty("errors")
    private List<ErrorsEntry> errors;

    public OutdoorPredictionResponse() {
    }

    /**
     * @return охват по заданным критериям
     */
    public Long getReach() {
        return reach;
    }

    public OutdoorPredictionResponse withReach(Long reach) {
        this.reach = reach;
        return this;
    }

    /**
     * @return прогнозируемая емкость в OTS по заданным критериям
     */
    public Long getOtsCapacity() {
        return otsCapacity;
    }

    public OutdoorPredictionResponse withOtsCapacity(Long otsCapacity) {
        this.otsCapacity = otsCapacity;
        return this;
    }

    /**
     * @return расчетный охват меньше чем нижнее ограничение
     */
    public Long getReachLessThan() {
        return reachLessThan;
    }

    public OutdoorPredictionResponse withReachLessThan(Long reachLessThan) {
        this.reachLessThan = reachLessThan;
        return this;
    }

    /**
     * @return возникшие ошибки
     */
    public List<ErrorsEntry> getErrors() {
        return errors;
    }

    public OutdoorPredictionResponse withErrors(List<ErrorsEntry> errors) {
        this.errors = errors;
        return this;
    }
}
