package ru.yandex.direct.inventori.model.response;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import ru.yandex.direct.inventori.model.response.error.PredictionResponseError;

/**
 * Необработанный результат вызова CPM-прогнозатора для получения цвета светофора и рекомендуемой цены.
 */
@JsonDeserialize(using = JsonDeserializer.None.class)
public class TrafficLightPredictionResponse extends CampaignPredictionResponse {

    @JsonProperty("traffic_light_colour")
    private final Integer trafficLightColor;

    @JsonProperty("recommended_cpm")
    private final Long recommendedCpm;

    public TrafficLightPredictionResponse(
            @JsonProperty("errors") List<PredictionResponseError> errors,
            @JsonProperty("traffic_light_colour") Integer trafficLightColor,
            @JsonProperty("recommended_cpm") Long recommendedCpm) {
        super(errors);
        this.recommendedCpm = recommendedCpm;
        this.trafficLightColor = trafficLightColor;
    }

    @Nullable
    public Long getRecommendedCpm() {
        return recommendedCpm;
    }

    @Nonnull
    public Integer getTrafficLightColor() {
        return trafficLightColor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrafficLightPredictionResponse that = (TrafficLightPredictionResponse) o;
        return Objects.equals(recommendedCpm, that.recommendedCpm) &&
                Objects.equals(trafficLightColor, that.trafficLightColor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(recommendedCpm, trafficLightColor);
    }
}
