package ru.yandex.direct.inventori.model.response.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type",
        visible = true, defaultImpl = PredictionResponseUnsupportedError.class)
@JsonSubTypes({
        @JsonSubTypes.Type(value = PredictionResponseInternalError.class, name = "INTERNAL_ERROR"),
        @JsonSubTypes.Type(value = PredictionResponseInvalidBudgetError.class, name = "INVALID_BUDGET"),
        @JsonSubTypes.Type(value = PredictionResponseInvalidCpmError.class, name = "INVALID_CPM"),
        @JsonSubTypes.Type(value = PredictionResponseInvalidDatesError.class, name = "INVALID_DATES"),
        @JsonSubTypes.Type(value = PredictionResponseInvalidRequestError.class, name = "INVALID_REQUEST"),
        @JsonSubTypes.Type(value = PredictionResponseInvalidRfError.class, name = "INVALID_RF"),
        @JsonSubTypes.Type(value = PredictionResponseUnknownSegmentsError.class, name = "UNKNOWN_SEGMENTS"),
        @JsonSubTypes.Type(value = PredictionResponseUnsupportedSegmentsError.class, name = "UNSUPPORTED_SEGMENTS"),
        @JsonSubTypes.Type(value = PredictionResponseNoGroupsError.class, name = "NO_GROUPS")
})
public abstract class PredictionResponseError {
    @JsonProperty("type")
    private final ErrorType type;

    @JsonCreator
    public PredictionResponseError(@JsonProperty("type") ErrorType type) {
        this.type = type;
    }

    public ErrorType getType() {
        return type;
    }
}
