package ru.yandex.direct.inventori.model.response.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class PredictionResponseInvalidBudgetError extends PredictionResponseError {
    @JsonProperty("invalid_budget")
    private final Long invalidBudget;

    @JsonCreator
    public PredictionResponseInvalidBudgetError(
            @JsonProperty("type") ErrorType type,
            @JsonProperty("invalid_budget") Long invalidBudget) {
        super(type);
        this.invalidBudget = invalidBudget;
    }

    public Long getInvalidBudget() {
        return invalidBudget;
    }
}
