package ru.yandex.direct.inventori.model.response.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class PredictionResponseInvalidCpmError extends PredictionResponseError {
    @JsonProperty("invalid_cpm")
    private final Long invalidCpm;

    @JsonCreator
    public PredictionResponseInvalidCpmError(
            @JsonProperty("type") ErrorType type,
            @JsonProperty("invalid_cpm") Long invalidCpm) {
        super(type);
        this.invalidCpm = invalidCpm;
    }

    public Long getInvalidCpm() {
        return invalidCpm;
    }
}
