package ru.yandex.direct.inventori.model.response.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class PredictionResponseInvalidDatesError extends PredictionResponseError {
    @JsonProperty("invalid_dates")
    private final String invalidDates;

    @JsonCreator
    public PredictionResponseInvalidDatesError(
            @JsonProperty("type") ErrorType type,
            @JsonProperty("invalid_dates") String invalidDates) {
        super(type);
        this.invalidDates = invalidDates;
    }

    public String getInvalidDates() {
        return invalidDates;
    }
}
