package ru.yandex.direct.inventori.model.response.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class PredictionResponseInvalidRequestError extends PredictionResponseError {
    @JsonProperty("message")
    private final String message;
    @JsonProperty("traceback")
    private final String traceback;

    @JsonCreator
    public PredictionResponseInvalidRequestError(
            @JsonProperty("type") ErrorType type,
            @JsonProperty("message") String message,
            @JsonProperty("traceback") String traceback) {
        super(type);
        this.message = message;
        this.traceback = traceback;
    }

    public String getMessage() {
        return message;
    }

    public String getTraceback() {
        return traceback;
    }
}
