package ru.yandex.direct.inventori.model.response.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class PredictionResponseInvalidRfError extends PredictionResponseError {
    @JsonProperty("invalid_rf")
    private final String invalidRf;

    @JsonCreator
    public PredictionResponseInvalidRfError(
            @JsonProperty("type") ErrorType type,
            @JsonProperty("invalid_rf") String invalidRf) {
        super(type);
        this.invalidRf = invalidRf;
    }

    public String getInvalidRf() {
        return invalidRf;
    }
}
