package ru.yandex.direct.inventori.model.response.error;

import java.util.LinkedHashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;

import static ru.yandex.direct.inventori.model.response.error.ErrorType.UNSUPPORTED_ERROR;

public class PredictionResponseUnsupportedError extends PredictionResponseError {
    private Map<String, Object> properties = new LinkedHashMap<>();

    public PredictionResponseUnsupportedError() {
        super(UNSUPPORTED_ERROR);
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.properties.put(name, value);
    }

    @JsonProperty("type")
    public void setType(String type) {
        this.properties.put("type", type);
    }

    public Map<String, Object> getProperties() {
        return properties;
    }
}
