package ru.yandex.direct.inventori.model.response.error;

import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class PredictionResponseUnsupportedSegmentsError extends PredictionResponseError {
    @JsonProperty("segment_ids")
    private final List<String> segmentIds;

    @JsonCreator
    public PredictionResponseUnsupportedSegmentsError(
            @JsonProperty("type") ErrorType type,
            @JsonProperty("segment_ids") List<String> segmentIds) {
        super(type);
        this.segmentIds = segmentIds;
    }

    public List<String> getSegmentIds() {
        return Collections.unmodifiableList(segmentIds);
    }
}
