package ru.yandex.direct.jcommander;

import java.time.Duration;
import java.time.format.DateTimeParseException;

import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.BaseConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationConverter extends BaseConverter<Duration> {
    private static final Logger logger = LoggerFactory.getLogger(DurationConverter.class);

    public DurationConverter(String optionName) {
        super(optionName);
    }

    @Override
    public Duration convert(String value) {
        try {
            return Duration.parse(value);
        } catch (DateTimeParseException ex) {
            logger.error("can't convert '{}' to Duration", value, ex);
            throw new ParameterException(getErrorString(value, "an Duration"));
        }
    }
}
