package ru.yandex.direct.jcommander;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;

public class ParserWithHelp {
    @Parameter(names = {"-h", "--help"}, help = true, description = "Display this page.")
    public boolean help;

    public static void parse(String programName, String[] args, Object... paramsList) {
        JCommander commander = new JCommander();
        commander.setProgramName(programName);
        parse(commander, args, paramsList);
    }

    public static void parse(JCommander commander, String[] args, Object... paramsList) {
        ParserWithHelp help = new ParserWithHelp();
        commander.addObject(help);
        for (Object params : paramsList) {
            commander.addObject(params);
        }
        try {
            commander.parse(args);
        } catch (ParameterException exc) {
            printErrorAndExit(exc);
        }
        if (help.help) {
            commander.usage();
            System.exit(0);
        }
    }

    public static Command parseCommand(String programName, String[] args, Object parameters, Command... commands) {
        JCommander commander = new JCommander();
        commander.setProgramName(programName);
        for (Command command : commands) {
            commander.addCommand(command.getCommandName(), command);
        }
        parse(commander, args, parameters);
        try {
            for (Command command : commands) {
                if (command.getCommandName().equals(commander.getParsedCommand())) {
                    command.validate();
                    return command;
                }
            }
            throw new ParameterException("Missing command.");
        } catch (ParameterException exc) {
            printErrorAndExit(exc);
        }
        return null;
    }

    public static void printErrorAndExit(ParameterException t) {
        System.err.println("Wrong usage: " + t.getMessage());
        System.err.println("See --help for details.");
        System.exit(1);
    }
}
