package ru.yandex.direct.jcommander;

import java.net.MalformedURLException;
import java.net.URL;

import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.BaseConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLConverter extends BaseConverter<URL> {
    private static final Logger logger = LoggerFactory.getLogger(URLConverter.class);

    public URLConverter(String optionName) {
        super(optionName);
    }

    @Override
    public URL convert(String value) {
        try {
            return new URL(value);
        } catch (MalformedURLException ex) {
            logger.error("can't convert '{}' to URL", value, ex);
            throw new ParameterException(getErrorString(value, "an URL"));
        }
    }
}
