package ru.yandex.direct.jooqmapper;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;

import ru.yandex.direct.jooqmapper.commonread.CommonReaderWithSupplier;
import ru.yandex.direct.jooqmapper.commonwrite.CommonWriter;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.write.JooqWriter;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

@ParametersAreNonnullByDefault
public class JooqMapperWithSupplier<M extends Model> extends JooqMapper<M> {

    public JooqMapperWithSupplier(JooqReaderWithSupplier<M> readOnlyJooqMapper,
                                  JooqWriter<M> jooqWriter) {
        super(readOnlyJooqMapper, jooqWriter);
    }

    public JooqMapperWithSupplier(CommonReaderWithSupplier<M> commonReaderWithSupplier,
                                  CommonWriter<M> commonWriter) {
        super(commonReaderWithSupplier, commonWriter);
    }

    public M fromDb(Record record) {
        CommonReaderWithSupplier<M> commonReaderWithSupplier =
                (CommonReaderWithSupplier<M>) commonReader;
        return commonReaderWithSupplier.fromDb(record);
    }

    public M fromDb(Record record, List<ModelProperty<? super M, ?>> modelProperties) {
        CommonReaderWithSupplier<M> commonReaderWithSupplier =
                (CommonReaderWithSupplier<M>) commonReader;
        return commonReaderWithSupplier.fromDb(record, modelProperties);
    }
}
