package ru.yandex.direct.jooqmapper;

import java.util.function.Supplier;

import org.jooq.Record;
import org.jooq.TableField;

import ru.yandex.direct.jooqmapper.commonread.CommonReaderWithSupplier;
import ru.yandex.direct.jooqmapper.commonread.CommonReaderWithSupplierBuilder;
import ru.yandex.direct.jooqmapper.commonwrite.CommonWriterBuilder;
import ru.yandex.direct.jooqmapper.read.DefaultReaderBuilder;
import ru.yandex.direct.jooqmapper.read.Reader1Builder;
import ru.yandex.direct.jooqmapper.read.Reader2Builder;
import ru.yandex.direct.jooqmapper.read.Reader3Builder;
import ru.yandex.direct.jooqmapper.read.ReaderBuilders;
import ru.yandex.direct.jooqmapper.write.DefaultWriterBuilder;
import ru.yandex.direct.jooqmapper.write.SupplierWriterBuilder;
import ru.yandex.direct.jooqmapper.write.Writer1Builder;
import ru.yandex.direct.jooqmapper.write.Writer2Builder;
import ru.yandex.direct.jooqmapper.write.Writer3Builder;
import ru.yandex.direct.jooqmapper.write.WriterBuilders;
import ru.yandex.direct.jooqmapper.write.WriterToFieldBuilder;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

/**
 * Билдер для создания {@link JooqMapperWithSupplier}.
 * Используйте вместе с {@link ReaderBuilders}, {@link WriterBuilders} и {@link ReaderWriterBuilders}.
 */
public class JooqMapperWithSupplierBuilder<M extends Model> extends JooqMapperBuilder<M> {

    private JooqMapperWithSupplierBuilder(Supplier<M> modelSupplier) {
        super(CommonReaderWithSupplierBuilder.builder(modelSupplier), CommonWriterBuilder.builder());
    }

    private JooqMapperWithSupplierBuilder(JooqMapper<? super M> sourceMapper,
                                          Supplier<M> modelSupplier) {
        super(CommonReaderWithSupplierBuilder.builder(sourceMapper.commonReader, modelSupplier),
                CommonWriterBuilder.builder(sourceMapper.commonWriter));
    }

    public static <M extends Model> JooqMapperWithSupplierBuilder<M> builder(Supplier<M> modelSupplier) {
        return new JooqMapperWithSupplierBuilder<>(modelSupplier);
    }

    public static <M extends Model> JooqMapperWithSupplierBuilder<M> builder(
            JooqMapper<? super M> sourceMapper, Supplier<M> modelSupplier) {
        return new JooqMapperWithSupplierBuilder<>(sourceMapper, modelSupplier);
    }

    @Override
    public <T, X extends Record, R> JooqMapperWithSupplierBuilder<M> map(
            ReaderWriterBuilder<M, T, X, R> readerWriterBuilder) {
        return (JooqMapperWithSupplierBuilder<M>) super.map(readerWriterBuilder);
    }

    @Override
    public <T, R> JooqMapperWithSupplierBuilder<M> readProperty(ModelProperty<? super M, T> modelProperty,
                                                                Reader1Builder<R, T> reader1Builder) {
        return (JooqMapperWithSupplierBuilder<M>) super.readProperty(modelProperty, reader1Builder);
    }

    @Override
    public <T> JooqMapperWithSupplierBuilder<M> readProperty(
            ModelProperty<? super M, T> modelProperty,
            Reader1Builder.Reader1WithFieldStep<T> reader1Builder
    ) {
        return (JooqMapperWithSupplierBuilder<M>) super.readProperty(modelProperty, reader1Builder);
    }

    @Override
    public <T, R1, R2> JooqMapperWithSupplierBuilder<M> readProperty(
            ModelProperty<? super M, T> modelProperty,
            Reader2Builder<R1, R2, T> reader2Builder
    ) {
        return (JooqMapperWithSupplierBuilder<M>) super.readProperty(modelProperty, reader2Builder);
    }

    @Override
    public <T, R1, R2, R3> JooqMapperWithSupplierBuilder<M> readProperty(
            ModelProperty<? super M, T> modelProperty,
            Reader3Builder<R1, R2, R3, T> reader3Builder) {
        return (JooqMapperWithSupplierBuilder<M>) super.readProperty(modelProperty, reader3Builder);
    }

    @Override
    public <T> JooqMapperWithSupplierBuilder<M> readProperty(ModelProperty<? super M, T> modelProperty,
                                                             DefaultReaderBuilder<T> readerBuilder) {
        return (JooqMapperWithSupplierBuilder<M>) super.readProperty(modelProperty, readerBuilder);
    }

    @Override
    public <X extends Record, T, R> JooqMapperWithSupplierBuilder<M> writeField(
            TableField<X, R> tableField,
            Writer1Builder<? super M, T, R> writer1Builder
    ) {
        return (JooqMapperWithSupplierBuilder<M>) super.writeField(tableField, writer1Builder);
    }

    @Override
    public <X extends Record, T, R> JooqMapperWithSupplierBuilder<M> writeField(
            TableField<X, R> tableField,
            WriterToFieldBuilder<? super M, T, R> writerToFieldBuilder
    ) {
        return (JooqMapperWithSupplierBuilder<M>) super.writeField(tableField, writerToFieldBuilder);
    }

    @Override
    public <T> JooqMapperWithSupplierBuilder<M> writeField(
            TableField<?, T> tableField,
            Writer1Builder.Writer1WithPropertyStep<M, T> writer1Builder
    ) {
        return (JooqMapperWithSupplierBuilder<M>) super.writeField(tableField, writer1Builder);
    }

    @Override
    public <X extends Record, T1, T2, R> JooqMapperWithSupplierBuilder<M> writeField(
            TableField<X, R> tableField, Writer2Builder<? super M, T1, T2, R> writer2Builder) {
        return (JooqMapperWithSupplierBuilder<M>) super.writeField(tableField, writer2Builder);
    }

    @Override
    public <X extends Record, T1, T2, T3, R> JooqMapperWithSupplierBuilder<M> writeField(
            TableField<X, R> tableField, Writer3Builder<? super M, T1, T2, T3, R> writer3Builder) {
        return (JooqMapperWithSupplierBuilder<M>) super.writeField(tableField, writer3Builder);
    }

    @Override
    public <X extends Record, R> JooqMapperWithSupplierBuilder<M> writeField(
            TableField<X, R> tableField,
            DefaultWriterBuilder<? super M, R> defaultWriterBuilder
    ) {
        return (JooqMapperWithSupplierBuilder<M>) super.writeField(tableField, defaultWriterBuilder);
    }

    @Override
    public <X extends Record, R> JooqMapperWithSupplierBuilder<M> writeField(
            TableField<X, R> tableField,
            SupplierWriterBuilder<? super M, R> supplierWriterBuilder
    ) {
        return (JooqMapperWithSupplierBuilder<M>) super.writeField(tableField, supplierWriterBuilder);
    }

    @Override
    public JooqMapperWithSupplier<M> build() {
        CommonReaderWithSupplier<M> commonReaderWithSupplier =
                ((CommonReaderWithSupplierBuilder<M>) readerBuilder).build();
        return new JooqMapperWithSupplier<M>(commonReaderWithSupplier, writerBuilder.build());
    }
}
