package ru.yandex.direct.jooqmapper;

import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableField;

import ru.yandex.direct.model.ModelProperty;

@ParametersAreNonnullByDefault
public interface JooqModelToDbFieldValuesMapper<M> extends JooqModelToDbMapper<M> {
    /**
     * С помощью предварительно заданнных райтеров вычисляет из данных модели поля в базе для указанных проперти модели
     *
     * @param model               экземпляр модели
     * @param requestedProperties проперти модели для которых считаем значения
     * @param table               таблица
     * @return возвращает мапу значение по полю таблицы.
     */
    default <R extends Record> Map<TableField<R, ?>, ?> getDbFieldValues(
            M model,
            Table<R> table,
            Set<ModelProperty<? super M, ?>> requestedProperties) {
        return getDbFieldValues(model, table, requestedProperties, Set.of());
    }

    /**
     * Версия метода, принимающая explicitValueProperties.
     * Те TableField, для которых сконфигурированы explicitValues будут дополнительно включены в результат,
     * если в TableField мапится хотя бы одна property из {@code explicitValueProperties}.
     * <p>Алгоритм не идеальный, т.к. ModelProperty может мапится на несколько TableField и может получится так,
     * что мы запросим и включим explicitValue для одного TableField из за того, что произошли изменения в другом
     * TableField.
     */
    <R extends Record> Map<TableField<R, ?>, ?> getDbFieldValues(
            M model,
            Table<R> table,
            Set<ModelProperty<? super M, ?>> requestedProperties,
            Set<ModelProperty<? super M, ?>> explicitValueProperties);
}
